from pymol import cmd


@cmd.extend
def pairwise_distances(sele1, sele2):
    '''
DESCRIPTION

    Align and superpose two atom selections and report all distances
    of aligned atom pairs.

EXAMPLE

    fetch 1akeA 4akeA, async=0
    pairwise_distances 1akeA, 4akeA
    '''
    alnobj = cmd.get_unused_name('aln')

    cmd.align(sele1, sele2, object=alnobj)

    aln = cmd.get_raw_alignment(alnobj)

    # mapping of (model,index) keys to xyz-coordinates and
    # identifier macro in slash notation
    mapping = {}

    for sele in [sele1, sele2]:
        cmd.iterate_state(1, sele,
                'mapping[model,index] = '
                '[x,y,z,"/%s/%s/%s/%s`%s/%s" % '
                '(model,segi,chain,resn,resi,name)]',
                space={'mapping': mapping})

    for idx1, idx2 in aln:
        atom1 = mapping[idx1]
        atom2 = mapping[idx2]

        d = sum((atom1[i] - atom2[i])**2 for i in range(3))**0.5

        print(atom1[3], atom2[3], d)


# auto-completion
cmd.auto_arg[0]['pairwise_distances'] = cmd.auto_arg[0]['zoom']
cmd.auto_arg[1]['pairwise_distances'] = cmd.auto_arg[0]['zoom']
