from pymol import cmd


@cmd.extend
def center_of_mass(selection='all', state=1, quiet=1):
    '''
DESCRIPTION

    Calculates the center of mass of an atom selection
    '''
    from chempy import atomic_mass

    coords = []

    cmd.iterate_state(state, selection,
            'coordinates.append([x,y,z,elem])',
            space={'coordinates': coords})

    if len(coords) == 0:
        print('Empty selection')
        return

    center = [0, 0, 0]
    total_mass = 0.0

    for xyz in coords:
        mass = atomic_mass[xyz[3]]
        center[0] += xyz[0] * mass
        center[1] += xyz[1] * mass
        center[2] += xyz[2] * mass
        total_mass += mass

    center[0] /= total_mass
    center[1] /= total_mass
    center[2] /= total_mass

    if not int(quiet):
        print('Center of Mass: ' + str(center))

    return center


# auto-completion
cmd.auto_arg[0]['center_of_mass'] = cmd.auto_arg[0]['zoom']
