from pymol import cmd

##########################################################
# ALTERNATIVE IMPLEMENTATION USING A CALLBACK FUNCTION
# INSTEAD OF EXTRACTING THE LIST OF ALL COORDINATES
##########################################################

@cmd.extend
def center_of_mass(selection='all', state=1, quiet=1):
    from chempy import atomic_mass

    # x, y, z, total_mass
    accum = [0., 0., 0., 0.]

    def callback(x, y, z, elem):
        mass = atomic_mass[elem]
        accum[0] += x * mass
        accum[1] += y * mass
        accum[2] += z * mass
        accum[3] += mass

    n = cmd.iterate_state(state, selection,
            'callback(x,y,z,elem)',
            space={'callback': callback})

    if n == 0:
        print('Empty selection')
        return

    center = [accum[i] / accum[3] for i in range(3)]

    if not int(quiet):
        print('Center of Mass: ' + str(center))

    return center


# auto-completion
cmd.auto_arg[0]['center_of_mass'] = cmd.auto_arg[0]['zoom']


