from pymol import cmd


@cmd.extend
def formula(selection='all', quiet=1):
    '''
DESCRIPTION

    Get the molecular formula of a selection.

USAGE

    formula [ selection [, quiet ]]

EXAMPLE

    PyMOL>formula organic
    FORMUL   P3 C21 H26 O17 N7 2-
    '''
    from collections import defaultdict

    # dictionary with auto-zero initialization
    elemcounts = defaultdict(int)

    cmd.iterate(selection,
        'elemcounts[elem] += 1',
        space={'elemcounts': elemcounts})

    # list, elements can be modified in iterate namespace
    totalcharge = [0]

    cmd.iterate(selection,
        'totalcharge[0] += formal_charge',
        space={'totalcharge': totalcharge})

    formula = ''

    for (elem, count) in elemcounts.items():
        formula += elem + str(count) + ' '

    formula += str(abs(totalcharge[0]))

    if totalcharge[0] > 0:
        formula += '+'
    elif totalcharge[0] < 0:
        formula += '-'

    if not int(quiet):
        print('FORMUL   ' + formula)

    return formula


# auto-completion
cmd.auto_arg[0]['formula'] = cmd.auto_arg[0]['zoom']
