# Bind two F-keys to set black and white background color (Use bg_color command)
set_key F1, bg_color black
set_key F2, bg_color white

# Bind two F-keys to show and hide the sequence viewer (seq_view setting)
set_key F3, set seq_view
set_key F4, set seq_view, off

# Bind one F-key to toggle the sequence viewer
cmd.set_key('F5', lambda: cmd.set('seq_view', not cmd.get_setting_int('seq_view')))

# Bind "ligand zoom" to an F-key (Use zoom or orient and the organic selector)
set_key F6, zoom bymol first organic, animate=1

# Write a "ligand zoom" command
alias ligandzoom, zoom bymol first organic, animate=1
